/*
 * Recorder.java
 *
 * Created on February 5, 2004, 3:58 PM
 */

import java.io.IOException;
import java.io.File;

import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.AudioFileFormat;

/**
 *
 * @author  jonbrown
 */
public class Recorder extends Thread {   
    
    private TargetDataLine m_line;
    private AudioFileFormat.Type m_targetType;
    private AudioInputStream m_audioInputStream;
    private File m_outputFile;

    /** Creates a new instance of Recorder */
    public Recorder(TargetDataLine line, 
            AudioFileFormat.Type targetType, File file) {
        m_line = line;
        m_audioInputStream = new AudioInputStream(line);
        m_targetType = targetType;
        m_outputFile = file;
    }

    public void start() {
        m_line.start();
        super.start();
    }
    
    public void stopRecording() {
        m_line.stop();
        m_line.close();
    }
  
    public void run() {
        try 
        {
            AudioSystem.write(
                m_audioInputStream,
                m_targetType,
                m_outputFile);
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
    }
}
